<?php $this->load->view("partial/header");

?>

<?php
if (isset($error_message))
{
	echo "<div class='alert alert-dismissible alert-danger'>".$error_message."</div>";
	exit;
}
?>

<?php if(!empty($customer_email)): ?>
	<script type="text/javascript">
		$(document).ready(function()
		{
			var send_email = function()
			{
				$.get('<?php echo site_url() . "/sales/send_pdf/" . $sale_id_num . "/quote"; ?>',
					function(response)
					{
						$.notify( { message: response.message }, { type: response.success ? 'success' : 'danger'} )
					}, 'json'
				);
			};

			$("#show_email_button").click(send_email);

			<?php if(!empty($email_receipt)): ?>
			send_email();
			<?php endif; ?>
		});
	</script>
<?php endif; ?>

<?php $this->load->view('partial/print_receipt', array('print_after_sale'=>$print_after_sale, 'selected_printer'=>'invoice_printer')); ?>

<div class="print_hide" id="control_buttons" style="text-align:right">
	<a href="javascript:printdoc();"><div class="btn btn-info btn-sm", id="show_print_button"><?php echo '<span class="glyphicon glyphicon-print">&nbsp</span>' . $this->lang->line('common_print'); ?></div></a>
	<?php /* this line will allow to print and go back to sales automatically.... echo anchor("sales", '<span class="glyphicon glyphicon-print">&nbsp</span>' . $this->lang->line('common_print'), array('class'=>'btn btn-info btn-sm', 'id'=>'show_print_button', 'onclick'=>'window.print();')); */ ?>
	<?php if(isset($customer_email) && !empty($customer_email)): ?>
		<a href="javascript:void(0);"><div class="btn btn-info btn-sm", id="show_email_button"><?php echo '<span class="glyphicon glyphicon-envelope">&nbsp</span>' . $this->lang->line('sales_send_quote'); ?></div></a>
	<?php endif; ?>
	<?php echo anchor("sales", '<span class="glyphicon glyphicon-shopping-cart">&nbsp</span>' . $this->lang->line('sales_register'), array('class'=>'btn btn-info btn-sm', 'id'=>'show_sales_button')); ?>
	<?php echo anchor("sales/discard_suspended_sale", '<span class="glyphicon glyphicon-remove">&nbsp</span>' . $this->lang->line('sales_discard'), array('class'=>'btn btn-danger btn-sm', 'id'=>'discard_quote_button')); ?>
</div>

<div id="page-wrap">
	<div id="header" style="margin-bottom:10px;"><?php echo $this->lang->line('sales_quote'); ?></div>
	<div id="block1">
	    <div id="logo" style="text-align:center; float:none;">
			<?php
			if($this->Appconfig->get('company_logo') != '')
			{
			?>
				<img id="image"  src="<?php echo base_url('uploads/' . $this->Appconfig->get('company_logo')); ?>" alt="company_logo" />
			<?php
			}
			?>
		
			
		</div>
		<div id="company-title"style="text-align:center;float:none;"><?php echo ($company_info) ?></div>

	</div>

	<div id="block2" style="padding-top:10px;">
		<table id="meta">
		    <tr>
		    <td class="meta-head"><?php echo $this->lang->line('employees_clerk');?></td>
		    <td><?php echo $employee; ?></td>
		    </tr>
			<tr>
				<td class="meta-head"><?php echo $this->lang->line('sales_quote_number');?></td>
				<td><?php echo $quote_number; ?></td>
			</tr>
			<tr>
				<td class="meta-head"><?php echo $this->lang->line('common_date'); ?></td>
				<td><?php echo $transaction_date; ?></td>
			</tr>
		
		</table>
		<div id="customer-title" style="float:none;margin-top:25px;">
			<?php
			if(isset($customer))
			{
			?>
				<div id="customer"><?php echo nl2br($customer_info) ?></div>
			<?php
			}
			?>
		    </div>
	</div>

	    	<table id="items">
		<tr>
			<th><?php echo $this->lang->line('sales_item_number'); ?></th>
			<th style="width: 5%;font-size: small;align: center;"><?php echo $this->lang->line('sales_item_id'); ?></th>
			<th><?php echo $this->lang->line('sales_item_name'); ?></th>
			<th><?php echo $this->lang->line('sales_quantity'); ?></th>
			<th><?php echo $this->lang->line('sales_price'); ?></th>
			<th><?php echo $this->lang->line('sales_discount'); ?></th>
			<?php
			$quote_columns = 7;
			if($discount > 0)
			{
				$quote_columns = $quote_columns + 1;
			?>
				<th><?php echo $this->lang->line('sales_customer_discount'); ?></th>
			<?php
			}
			?>
			
			
			<th><?php echo $this->lang->line('sales_total'); ?></th>
		</tr>

		<?php
		foreach($cart as $line=>$item)
		{
			if($item['print_option'] == PRINT_YES)
			{
			?>
				<tr class="item-row" style='font-size:10px;'>
					<td><?php echo $item['item_number']; ?></td>
					<td style="font-size: x-small;color: green; font-weight: bold;align: center;"><?php echo "[".$item['item_id']."]"; ?></td>
					<td class="item-name" style='width:300px;'><?php echo $item['name']; ?></td>
					<td style='text-align:center;'><?php echo to_quantity_decimals($item['quantity']); ?></td>
					<td><?php echo to_currency($item['price']); ?></td>
					<td style='text-align:center;'><?php echo ($item['discount_type']==FIXED)?to_currency($item['discount']):to_decimals($item['discount']) . '%';?></td>
					<?php if($discount > 0): ?>
				    <td style='text-align:center;'><?php echo to_currency($item['discounted_total'] / $item['quantity']); ?></td>
					<?php endif; ?>
					<td style='border-right: solid 1px; text-align:right;;'><?php echo to_currency($item['discounted_total']); ?></td>
				</tr>

				<?php if($item['is_serialized'])
				{
				?>
					<tr class="item-row" style="display: none;">
						<td class="item-name" colspan="<?php echo $quote_columns-1; ?>"></td>
						<td style='text-align:center;'><?php echo $item['serialnumber']; ?></td>
					</tr>
				<?php
				}
			}
		}
		?>

		<tr>
			<td class="blank" colspan="<?php echo $quote_columns; ?>" align="center"><?php echo '&nbsp;'; ?></td>
		</tr>
		<tr ><?php
			
			if($discount > 0)
			{
			?>
				<td colspan="<?php echo 6; ?>" class="blank"> </td>
			<?php
			}else {
			?>
			<td colspan="<?php echo 5; ?>" class="blank"> </td>
			<?php
			}
			?>
			
		
			<td colspan="1" class="total-line" style="text-align:right;font-size:10px;"><?php echo $this->lang->line('sales_total'); ?></td>
			<td class="total-value"style="text-align:center;font-size:10px; " id="total"><?php echo to_currency($total); ?></td>
		</tr>

		<!--<?php
		$only_sale_check = FALSE;
		$show_giftcard_remainder = FALSE;
		foreach($payments as $payment_id=>$payment)
		{
			$only_sale_check |= $payment['payment_type'] == $this->lang->line('sales_check');
			$splitpayment = explode(':', $payment['payment_type']);
			$show_giftcard_remainder |= $splitpayment[0] == $this->lang->line('sales_giftcard');
		?>
			<tr>
				<td colspan="<?php echo $quote_columns-3; ?>" class="blank"> </td>
				<td colspan="2" class="total-line"><?php echo $splitpayment[0]; ?></td>
				<td class="total-value" id="paid"><?php echo to_currency( $payment['payment_amount'] ); ?></td>
			</tr>
		<?php
		}
		?>-->
	</table>
	<div id="terms">
		<div id="sale_return_policy">
		        
			<h5>			
				<div style="padding:4%; font-size:10px;"><?php echo empty($comments) ? '' : $this->lang->line('sales_comments') . ': ' . $comments; ?>
				<div style="page-break-before: auto"></div></div>
				<div style='padding:4%;font-size:10px;'><?php echo $this->config->item('quote_default_comments'); ?>
				<div style="page-break-before: auto"></div></div>
			</h5>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(window).on("load", function()
	{
		// install firefox addon in order to use this plugin
		if (window.jsPrintSetup)
		{
			<?php
			if(!$this->Appconfig->get('print_header'))
			{
			?>
				// set page header
				jsPrintSetup.setOption('headerStrLeft', '');
				jsPrintSetup.setOption('headerStrCenter', '');
				jsPrintSetup.setOption('headerStrRight', '');
			<?php
			}

			if(!$this->Appconfig->get('print_footer'))
			{
			?>
				// set empty page footer
				jsPrintSetup.setOption('footerStrLeft', '');
				jsPrintSetup.setOption('footerStrCenter', '');
				jsPrintSetup.setOption('footerStrRight', '');
			<?php
			}
			?>
		}
	});
</script>

<?php $this->load->view("partial/footer"); ?>